;; This example shows a simple raster using the CPC+ 
;; extended palette, and using standard CPC compatible 
;; raster interrupts to define the position of the raster 
;; on the display.
;; 
;; This example is designed for CPC+ only and will
;; not work on CPC or KC Compact.
;;
;;
;; This example will compile with the MAXAM assembler
;; or the built-in assembler of WinAPE32.


;; NOTE - For this example to work, the code must not
;; be in the range &4000-&7fff inclusive. The ASIC registers
;; are paged into this range, and the code would not be
;; visible to the CPU if it was also in this range.
org &8000

.scr_set_mode equ &bc0e

;;--------------------------------------------------
;; clear screen
ld a,1
call scr_set_mode

;;--------------------------------------------------
;; STEP 1 - Unlock CPC+ additional features
;; unlock asic to gain access to asic registers

di
ld b,&bc
ld hl,sequence
ld e,17
.seq 
ld a,(hl)
out (c),a
inc hl
dec e
jr nz,seq
ei

;;----------------------------------------------------------
;; STEP 2 - Install a interrupt handler
;;
;; install a interrupt handler

;; disable interrupts
di
;; interrupt mode 1 (call to interrupt handler at &0038)
im 1

;; &c9 corresponds to the opcode RET
;; &fb corresponds to the opcode EI
;;
;; RET opcode takes 3us, EI opcode takes 1us

;; write EI,RET to interrupt handler at &0038
ld hl,&c9fb
ld (&0038),hl

;; enable interrupts
ei

;;------------------------------------------------------------

.main_loop

;;---------------------------------------
;; wait for start of vsync
;;
;; at this point the code assumes the VSYNC is not active.
;;
;; this code waits for the VSYNC to change from inactive->active
;; which signals the start of the VSYNC.

;; PPI port B
ld b,&f5

.ml1
;; read input
in a,(c)
;; transfer bit 0 into carry
;; if bit 0=1 then VSYNC is active, if bit 0=0 then VSYNC is inactive
rra
jr nc,ml1
;;----------------------------------------

;; wait for interrupt
halt

;; wait for interrupt
halt

;; wait for interrupt
halt

;; wait for interrupt
halt

;; delay so that colour change position is not visible (hidden
;; by border and horizontal flyback)
defs 20

;; page-in asic registers to &4000-&7fff
ld bc,&7fb8					;; [3]
out (c),c					;; [4]

ld de,&6400					;; colour 0

;; start of table
ld hl,raster_colours
;; number of colours in table
ld b,end_raster_colours-raster_colours   
;; /2
srl b

.rl
;; read colour from table (a byte at a time)
;; write colour to ASIC colour palette (a byte at a time)

ld a,(hl)					;; [2]
ld (de),a					;; [2]
inc hl						;; [2]
inc e						;; [1]
ld a,(hl)					;; [2]
ld (de),a					;; [2]
inc hl						;; [2]
dec e						;; [1]

;; delay so that the next colour change
;; occurs immediatly below this one
defs 64-2-2-2-1-2-2-2-1-1-3

dec b						;; [1]
jp nz,rl					;; [3]

;; page-out asic registers
ld bc,&7fa0
out (c),c

jp main_loop

;;---------------------------------------------

;; - there is two bytes per colour.
;; - these are stored in a form that can be written direct 
;; to the CPC+ colour palette registers
;; e.g. xGRB
.raster_colours
defw &0111
defw &0222
defw &0333
defw &0444
defw &0555
defw &0666
defw &0777
defw &0888
defw &0999
defw &0aaa
defw &0bbb
defw &0ccc
defw &0ddd
defw &0eee
defw &0fff
defw &0fff
defw &0eee
defw &0ddd
defw &0ccc
defw &0bbb
defw &0aaa
defw &0999
defw &0888
defw &0777
defw &0666
defw &0555
defw &0444
defw &0333
defw &0222
defw &0111
defw &0000
.end_raster_colours

;;----------------------------------------------------------
;; this is the sequence to unlock the ASIC extra features
.sequence
defb &ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee